<?php
// Inclua o autoload do Composer (certifique-se de que o Composer está instalado e a biblioteca smalot/pdfparser está configurada)
require 'vendor/autoload.php';

use Smalot\PdfParser\Parser;

// Verifica se um arquivo foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['arquivo_pdf'])) {
    $arquivo = $_FILES['arquivo_pdf']['tmp_name']; // Caminho temporário do arquivo

    // Verifica se o arquivo é um PDF
    if ($_FILES['arquivo_pdf']['type'] === 'application/pdf') {
        // Cria uma instância do parser
        $parser = new Parser();

        try {
            // Faz o parsing do PDF
            $pdf = $parser->parseFile($arquivo);

            // Obtém os metadados do PDF
            $metadados = $pdf->getDetails();

            // Exibe os metadados
            echo "<h2>Metadados do PDF:</h2>";
            echo "<pre>";
            print_r($metadados);
            echo "</pre>";
        } catch (Exception $e) {
            echo "<p style='color: red;'>Erro ao processar o PDF: " . $e->getMessage() . "</p>";
        }
    } else {
        echo "<p style='color: red;'>Por favor, envie um arquivo PDF válido.</p>";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Leitor de Metadados de PDF</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
        }
        h1 {
            text-align: center;
        }
        form {
            margin-bottom: 20px;
        }
        input[type="file"] {
            margin-bottom: 10px;
        }
        pre {
            background: #f4f4f4;
            padding: 10px;
            border-radius: 5px;
            overflow-x: auto;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Leitor de Metadados de PDF</h1>
        <form action="" method="post" enctype="multipart/form-data">
            <label for="arquivo_pdf">Selecione um arquivo PDF:</label>
            <input type="file" name="arquivo_pdf" id="arquivo_pdf" accept="application/pdf" required>
            <button type="submit">Enviar e Ler Metadados</button>
        </form>

        <?php
        // Exibe os metadados aqui, se houver
        if (isset($metadados)) {
            echo "<h2>Metadados do PDF:</h2>";
            echo "<pre>";
            print_r($metadados);
            echo "</pre>";
        }
        ?>
    </div>
</body>
</html>